//
//  ButtonPullDownRealize.m
//  22222222222222
//
//  Created by liangchenying on 12-4-9.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ButtonPullDownRealize.h"

@implementation ButtonPullDownRealize

@synthesize strings      = _strings;
@synthesize index        = _index;
@synthesize DoneButton   = _DoneButton;
@synthesize CancelButton = _cancelButton;


+ (id)sheetPickerTitle:(NSString *)title Sheet:(NSArray *)strings Selected:(NSInteger)index DoneButton:(PickerActionDoneButton)DoneButton CancelButton:(PickerActionCancelButton)cancelBlockOrNil Action:(id)Action{
    if(strings == nil || [strings count] == 0)    return nil;
    
    ButtonPullDownRealize * picker = [[ButtonPullDownRealize alloc] initWithTitle:title Sheet:strings Selected:index DoneButton:DoneButton CancelButton:cancelBlockOrNil Action:Action];
    
	[picker showSheetPicker];
    
    return [picker autorelease];
}

- (id)initWithTitle:(NSString *)title Sheet:(NSArray *)strings Selected:(NSInteger)index DoneButton:(PickerActionDoneButton)DoneButton CancelButton:(PickerActionCancelButton)CancelButton Action:(id)Action{
    self = [self initWithTarget:Action];
    
    if (self){
        self.title   = title;
        self.strings = strings;
        self.index   = index;
        
        self.DoneButton   = DoneButton;
        self.CancelButton = CancelButton;
    }
    
    return self;
}

- (void)dealloc {
    self.strings = nil;
    
    Block_release(_DoneButton);
    Block_release(_cancelButton);

    [super dealloc];
}

- (UIView *)configuredPickerView{
    if (! self.strings){
        return nil;
    }
    
    CGSize screenSize = UIScreen.mainScreen.bounds.size;
    CGFloat stringPickerWidth = 0;
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPhone) {
        stringPickerWidth = screenSize.width;
    } else {
        stringPickerWidth = 320;
    }
    
    const int PICKER_HEIGHT = 216;
    UIPickerView *stringPicker = [[[UIPickerView alloc] initWithFrame:CGRectMake(0, 40, stringPickerWidth, PICKER_HEIGHT)] autorelease];     // fixed y and width
    
    stringPicker.delegate                = self;
    stringPicker.dataSource              = self;
    stringPicker.showsSelectionIndicator = YES;
    
    [stringPicker selectRow:self.index inComponent:0 animated:NO];
    
  return stringPicker;

}

- (void)notifyDoneButton {
    if (self.DoneButton) {
        _DoneButton(self, self.index, [self.strings objectAtIndex:self.index]);
    }
}

- (void)notifyCancelButton{
    if (self.CancelButton){
        _cancelButton(self);
    }
}

// UIPickerViewDataSource(@required)

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView {
    return 1;
}


- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
    return self.strings.count;
}

// UIPickerViewDelegate(@optional)

- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)Selected forComponent:(NSInteger)component {
    return self.strings[Selected];
   // return [self.strings objectAtIndex:Selected];
}

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)Selected inComponent:(NSInteger)component {
    self.index = Selected;
}

// Setters

- (void)setOnActionSheetDone:(PickerActionDoneButton)DoneButton{
    if (_DoneButton){
        Block_release(_DoneButton);
    }
    
    _DoneButton = Block_copy(DoneButton);
}

- (void)setOnActionSheetCancel:(PickerActionCancelButton)CancelButton{
    if (_cancelButton) {
        Block_release(_cancelButton);
    }
    
    _cancelButton = Block_copy(CancelButton);
}

@end
